import pika

def publish_message():
    connection = pika.BlockingConnection(pika.ConnectionParameters('localhost'))
    channel = connection.channel()

    channel.exchange_declare(exchange='topic_logs', exchange_type='topic')

    while True:
        routing_key = input("Mesaj için routing_key girin (örnek: 'info.system', 'error.network'): ").strip()
        message = input("Gönderilecek mesajı yazın: ").strip()

        if not routing_key or not message:
            print("Mesaj gönderimi sonlandırıldı.")
            break

        channel.basic_publish(exchange='topic_logs', routing_key=routing_key, body=message)
        print(f"[x] Gönderilen Mesaj: {message} (Routing Key: {routing_key})")

    connection.close()

if __name__ == "__main__":
    publish_message()
