import pika

def callback(ch, method, properties, body):
    print(f"[Consumer 1] Alınan Mesaj: {body.decode()} (Routing Key: {method.routing_key})")

connection = pika.BlockingConnection(pika.ConnectionParameters('localhost'))
channel = connection.channel()

channel.exchange_declare(exchange='topic_logs', exchange_type='topic')

queue = channel.queue_declare(queue='', exclusive=True)
queue_name = queue.method.queue

channel.queue_bind(exchange='topic_logs', queue=queue_name, routing_key='info.#')

print(' [*] Consumer 1, "info.#" mesajlarını bekliyor.')
channel.basic_consume(queue=queue_name, on_message_callback=callback, auto_ack=True)

channel.start_consuming()
