import pika

def callback(ch, method, properties, body):
    print(f"[Consumer 2] Alınan Mesaj: {body.decode()} (Headers: {properties.headers})")

connection = pika.BlockingConnection(pika.ConnectionParameters('localhost'))
channel = connection.channel()
channel.exchange_declare(exchange='header_logs', exchange_type='headers')

queue = channel.queue_declare(queue='', exclusive=True)
queue_name = queue.method.queue

channel.queue_bind(
    exchange='header_logs',
    queue=queue_name,
    arguments={'key1': 'value3', 'key2': 'value4', 'x-match': 'any'}
)

print(' [*] Consumer 2, başlıkları "key1=value3 veya key2=value4" olan mesajları bekliyor.')

channel.basic_consume(queue=queue_name, on_message_callback=callback, auto_ack=True)
channel.start_consuming()
