import pika
def publish_message():
    connection = pika.BlockingConnection(pika.ConnectionParameters('localhost'))
    channel = connection.channel()
    channel.exchange_declare(exchange='header_logs', exchange_type='headers')
    while True:
        key1 = input("Header 'key1' için bir değer girin (örnek: 'value1'): ").strip()
        key2 = input("Header 'key2' için bir değer girin (örnek: 'value2'): ").strip()
        message = input("Gönderilecek mesajı yazın: ").strip()
        if not key1 or not key2 or not message:
            print("Mesaj gönderimi sonlandırıldı.")
            break
        headers = {'key1': key1, 'key2': key2}
        channel.basic_publish(
            exchange='header_logs',
            routing_key='',  
            body=message,
            properties=pika.BasicProperties(headers=headers),
        )
        print(f"[x] Gönderilen Mesaj: {message} (Headers: {headers})")
    connection.close()
    
if __name__ == "__main__":
    publish_message()
